﻿using System;
using VA.TMP.Integration.VIMT.Mvi.StateObject;
using VA.TMP.Integration.VIMT.Shared;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Mvi.PipelineSteps.ProxyAdd
{
    /// <summary>
    /// Send Provider Veteran Identifier to EC step.
    /// </summary>
    public class SendProviderVeteranIdentifierToEcStep : FilterBase<ProxyAddStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(ProxyAddStateObject state)
        {
            if (string.IsNullOrEmpty(state.ProviderSite) || state.ProviderSideIdentifierToAdd == null || state.PatientAndProviderSitesAreEqual || state.ExceptionOccured || state.Veteran == null) return;

            try
            {
                MviUtilities.SendIdentifierToProxyAddEc(ref state, false);
            }
            catch (Exception ex)
            {
                var exceptionMessage = ex.Message;
                exceptionMessage += PipelineUtilities.BuildErrorMessage(ex);

                state.ExceptionOccured = true;
                state.ExceptionMessage = exceptionMessage;
            }
        }
    }
}